% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_lab.R
\name{fig_lab}
\alias{fig_lab}
\title{Add Label to a Fig}
\usage{
fig_lab(
  fig,
  lab,
  pos = "bottom",
  fontfamily = NULL,
  fontface = NULL,
  colour = NULL,
  size = NULL,
  lineheight = NULL,
  hjust = NULL,
  vjust = NULL,
  angle = NULL,
  margin = ggplot2::margin(4, 4, 4, 4)
)
}
\arguments{
\item{fig}{Fig to be labelled.}

\item{lab}{String of label to be added to the fig.}

\item{pos}{Position of the fig, either 'top', 'bottom', 'left', or 'right'.}

\item{fontfamily}{Font family for the label.}

\item{fontface}{Font face for the label (i.e. "italic")}

\item{colour}{Colour of the label text.}

\item{size}{Size of the label text.}

\item{lineheight}{Lineheight of the label text.}

\item{hjust}{hjust of the label text.}

\item{vjust}{vjust of the label text.}

\item{angle}{Angle of the label text.}

\item{margin}{Margin around the label text. Use \code{ggplot2::margin()}}
}
\value{
\code{\{ggplot2\}} object
}
\description{
Add Label to a Fig
}
\examples{

library(figpatch)
library(ggplot2)

# Attach the fig image file
image <- system.file("extdata", "fig.png", package = "figpatch", mustWork = TRUE)

# Read in the image as a 'fig'
img <- fig(image)

# add the fig label
fig_lab(
  img,
  lab = "Below you will find a fig!",
  pos = "top",
  size = 20
)
}
