% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-caps.R
\name{autoplot.mcaps}
\alias{autoplot.mcaps}
\title{Visualizes results of multiple clustering strategies using ggplot2}
\usage{
\method{autoplot}{mcaps}(
  object,
  validation_criterion = c("wss", "silhouette"),
  what = c("mean", "distribution"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{mcaps}.}

\item{validation_criterion}{A string specifying the validation criterion to
be used for the comparison. Choices are \code{"wss"} or \code{"silhouette"}. Defaults
to \code{"wss"}.}

\item{what}{A string specifying the kind of information to display about the
validation criterion. Choices are \code{"mean"} (which plots the mean values) or
\code{"distribution"} (which plots the boxplots). Defaults to \code{"mean"}.}

\item{...}{Other arguments passed to specific methods.}
}
\value{
An object of class \code{\link[ggplot2:ggplot]{ggplot2::ggplot}}.
}
\description{
This is an S3 method implementation of the \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}} generic
for objects of class \code{mcaps} to visualize the performances of multiple
\code{\link{caps}} objects applied on the same data sets either in terms of WSS or in
terms of silhouette values.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
p <- ggplot2::autoplot(sim30_mcaps)
\dontshow{\}) # examplesIf}
}
