% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sankey.R
\name{plot_sankey}
\alias{plot_sankey}
\title{Create a Sankey Plot to Visualise Patient Routing}
\usage{
plot_sankey(
  raw_data,
  gnn_results,
  expert_results,
  group_mappings,
  group_var,
  verbose = FALSE
)
}
\arguments{
\item{raw_data}{The original, unscaled dataframe (must contain the features referenced by expert analysis).}

\item{gnn_results}{The results object from \code{train_gnn()} (uses $final_results and $gate_weights).}

\item{expert_results}{The results object from \code{analyse_experts()}.}

\item{group_mappings}{A named list or named character vector mapping \emph{codes} to \emph{labels}
(e.g., c("0"="Male","1"="Female")). If provided in the reverse orientation (labels→codes),
or unnamed, this function will normalise it automatically.}

\item{group_var}{A string with the column name of the sensitive attribute in the raw_data.}

\item{verbose}{Logical, whether to print progress messages (default FALSE).}
}
\value{
A ggplot object representing the Sankey diagram.
}
\description{
Create a Sankey Plot to Visualise Patient Routing
}
