% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.diagnostics.R
\name{plan.diagnostics}
\alias{plan.diagnostics}
\title{Plan-level diagnostics for ANOVA/rank-based workflows}
\usage{
plan.diagnostics(formula, data, force_factors = TRUE)
}
\arguments{
\item{formula}{A model formula of the form \code{y ~ A + B (+ C ...)}.}

\item{data}{A data frame containing the variables in the model.}

\item{force_factors}{Logical; if TRUE, coerces RHS predictors to factors.}
}
\value{
An invisible list with:
\itemize{
\item \code{$summary}: overall percent_ok, ok_count, total, overall, plus per-type percentages
(\code{percent_ok_normality_raw}, \code{percent_ok_residuals_cellwise},
\code{percent_ok_balance_chisq}, \code{percent_ok_levene_full_plan}).
\item \code{$results}: data.frames for \code{normality_raw},
\code{residuals_cellwise_normality}, \code{levene_full_plan}, \code{balance_chisq}.
}
}
\description{
Runs all assumption checks in one call: raw normality per subgroup (Shapiro-Wilk),
residual normality per cell (from a full-factorial ANOVA on the specified factors),
Levene/Brown-Forsythe for the full plan (median by default), and count-balance
chi-square tests for all factor combinations. Prints a concise summary and returns
all detailed tables in a list.
}
\details{
Requires helper functions defined in this package:
\code{normality.datatable}, \code{residuals.cellwise.normality.datatable},
\code{levene.plan.datatable}, \code{balance.chisq.datatable}.
Levene's test uses \pkg{car}; if unavailable, the Levene block returns NA rows with a warning.
}
\examples{
\dontrun{
diag_out <- plan.diagnostics(liking ~ gender + condition + age_cat, data = mimicry)
diag_out$summary
diag_out$results$normality_raw
}

}
\seealso{
\code{\link{normality.datatable}},
\code{\link{residuals.cellwise.normality.datatable}},
\code{\link{levene.plan.datatable}},
\code{\link{balance.chisq.datatable}}
}
