% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geo_codes.R
\name{get_geo_codes}
\alias{get_geo_codes}
\title{Get the ISO3 codes of standard country groups}
\usage{
get_geo_codes(geo_id, wiotype = "icio2025", icio_extend = FALSE)
}
\arguments{
\item{geo_id}{String, country group id. Available \code{geo_ids} for a
specific input-output table can be obtained with the command
\code{\link[=info_geo]{info_geo()}}.}

\item{wiotype}{String, type of input-output table.}

\item{icio_extend}{Boolean. If \code{TRUE} and the input-output table
is of type \code{icio} extended, codes will also include the extended elements
for China (\code{CN1}, \code{CN2}) and Mexico (\code{MX1}, \code{MX2}).}
}
\value{
Codes of country/countries ready to grep, e.g. \code{AUS|ARG|BEL}
}
\description{
Gets the ISO3 codes of standard country groups available for the
different input-output tables. The resulting format can be used to
extract elements of a matrix using \code{grep}.
}
\examples{
# Get the codes of EU27 countries
get_geo_codes("EU27", "icio2025")
# Gets the codes for NAFTA and extends MEX to MX1|MX2
get_geo_codes("NAFTA", "icio2025", icio_extend = TRUE)
}
