\name{exams2ans}
\alias{exams2ans}

\title{Generation of Quizzes for Ans}

\description{
  Automatic generation of exams in QTI 2.1 with some tweaks
  (still under development) for the online testing system Ans.
}

\usage{
exams2ans(file, n = 1L, dir = ".", name = "anstest",
  converter = "pandoc-mathjax", maxattempts = 1, cutvalue = NULL, \dots)
}


\arguments{
  \item{file}{character. A specification of a (list of) exercise files.}
  \item{n}{integer. The number of copies to be compiled from \code{file}.}
  \item{dir}{character. The default is the current working directory.}
  \item{name}{character. A name prefix for resulting exercises and XML file.}
  \item{converter}{character passed on to \code{\link[exams]{make_exercise_transform_html}},
    indicating the type of converter from LaTeX/Markdown to HTML.}
  \item{maxattempts}{integer. The maximum attempts for one question.} 
  \item{cutvalue}{numeric. The number of points at which the exam is passed.}     
  \item{\dots}{arguments passed on to \code{\link[exams]{exams2qti21}}.}
}

\details{
  \code{exams2ans} is a convenience interface to \code{\link[exams]{exams2qti21}}
  for generating QTI 2.1 with some small tweaks for Ans
  (\url{https://www.ans.app}). The supported exercise types at the
  moment are num, schoice, mchoice, and string. There is limited support for cloze exercises:
  It only allows for questions with similar item types (choice items versus fill-in items), meaning that 
  only combinations of schoice and mchoice items or combinations of numeric and string items
  are allowed.

  The Ans-specific tweaks currently include:
  \itemize{
    \item Ans only recognizes HTML with mathematical notation created with \code{"pandoc-mathjax"}, 
    which is set as default.
    \item The Ans system does not properly render html-\code{<pre>} environments and requires an
    additional adjustment of the QTI XML.
    \item Ans has its own unique way of setting tolerance for numeric questions, which is incorporated in 
    the function.
  }

}

\references{
Ans (2025). \emph{Exercises and Questions}.
  Available at \url{https://support.ans.app/hc/en-us/sections/360004983014-Exercises-Questions}

Zeileis A, Umlauf N, Leisch F (2014).
  Flexible Generation of E-Learning Exams in R: Moodle Quizzes, OLAT Assessments, and Beyond.
  \emph{Journal of Statistical Software}, \bold{58}(1), 1--36.
  \doi{10.18637/jss.v058.i01}.
}

\value{
  \code{exams2ans} returns a list of exams as generated by \code{\link[exams]{xexams}}.
}

\seealso{
  \code{\link[exams]{exams2qti21}}
}

\examples{
\donttest{
## load package and enforce par(ask = FALSE)
library("exams")
options(device.ask.default = FALSE)

## define an exams (= list of exercises)
myexam <- c(
  "boxplots.Rmd",
  "tstat.Rmd",
  "ttest.Rmd",
  "relfreq.Rmd",
  "fourfold.Rmd"
)

## output directory
dir.create(mydir <- tempfile())

## generate .zip with Ans test in temporary directory
exams2ans(myexam, dir = mydir)
dir(mydir)
}
}

\keyword{utilities}
