# tests/testthat/test-evidence_test.R

test_that("evidence_test returns a valid evidence_result object", {
  x <- sleep$extra[sleep$group == 1]

  res <- evidence_test(x)

  expect_s3_class(res, "evidence_result")
  expect_named(
    res,
    c("estimate", "interval", "interval_level", "log10_er",
      "null", "alternative", "model", "call")
  )

  expect_type(res$estimate, "double")
  expect_length(res$estimate, 1L)

  expect_type(res$interval, "double")
  expect_length(res$interval, 2L)

  expect_type(res$log10_er, "double")
  expect_length(res$log10_er, 1L)
  expect_false(is.na(res$log10_er))

})

