\name{piecewiseExp_test_changepoint}
\alias{piecewiseExp_test_changepoint}
\title{Wald test to infer change point in piecewise Exponential survival model}
\description{This function implements the Wald test described in Goodman et al (2011) and applied in Fang & Zheng (2011) to infer a change point in an estimated piecewise Exponential hazard function. Adjusts for sequential testing.}
\usage{piecewiseExp_test_changepoint(peMLE, alpha = 0.05)}
\arguments{
  \item{peMLE}{Piecewise Exponential hazard function estimate, as generated by \code{\link{piecewiseExp_MLE}}.}
  \item{alpha}{Overall significance level. Will be adjusted for sequential testing internally, see function output.}
}
\value{A \code{data.frame} containing the sequential test results.}

\author{
Kaspar Rufibach (maintainer) \cr \email{kaspar.rufibach@roche.com} 
}
\references{
Fang, L., Zheng, S. (2011).
A hybrid approach to predicting events in clinical trials with time-to-event outcomes.
\emph{Contemp. Clin. Trials}, \bold{32}, 755--759. 

Goodman, M.S., Li, Y., Tiwari, R.C. (2011).
Detecting multiple change points in piecewise constant hazard functions.
\emph{J. Appl. Stat}, \bold{38(11)}, 2523--2532.
}

\examples{# see vignette}
\keyword{htest}
