% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_timer.R
\name{with_timer}
\alias{with_timer}
\title{Wrap a function to measure and display execution time}
\usage{
with_timer(fn, name = "Task")
}
\arguments{
\item{fn}{A function to be wrapped.}

\item{name}{A short descriptive name of the task (used in log output).}
}
\value{
A function that executes \code{fn(...)} and prints timing information (returns invisibly).
}
\description{
Wraps a function with CLI-based timing and prints its runtime in seconds.
Useful for benchmarking or logging time-consuming tasks.
}
\details{
Requires the \code{tictoc} package (CLI messages are emitted via \code{cli}).
}
\examples{
slow_fn <- function(n) { Sys.sleep(0.01); n^2 }
timed_fn <- with_timer(slow_fn, name = "Square Task")
timed_fn(5)
}
