% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recovery_rate.R
\name{recovery_rate}
\alias{recovery_rate}
\title{Calculate the rate of recovery after disturbance}
\usage{
recovery_rate(
  type,
  b = NULL,
  metric_tf,
  response,
  summ_mode = "mean",
  b_tf = NULL,
  vd_i = NULL,
  td_i = NULL,
  d_data = NULL,
  vb_i = NULL,
  tb_i = NULL,
  b_data = NULL,
  comm_d = NULL,
  comm_b = NULL,
  comm_t = NULL,
  method = "bray",
  binary = "FALSE",
  na_rm = TRUE
)
}
\arguments{
\item{type}{a string defining the type of stability (\code{"functional"} or \code{"compositional"}) to be calculated.}

\item{b}{a string stating whether the baseline is defined by a separate
baseline that is specified by the user (\code{b = "input"}) or by a
period of the disturbed system (\code{b = "d"}) prior to the disturbance.
This period is specified by \code{b_tf}.}

\item{metric_tf}{a numerical vector, specifying the beginning and end of the
time period over which the stability metric should be measured.}

\item{response}{a string stating whether the stability metric should be
calculated using the log-response ratio between the values in the disturbed
system and the baseline (\code{response = "lrr"}) or using the state
variable values in the disturbed system alone (\code{response == "v"}).}

\item{summ_mode}{A string, stating whether the baseline should be summarized
as the mean (\code{summ_mode = "mean"}) or the median
(\code{summ_mode = "median"}). Defaults to "mean".}

\item{b_tf}{a numerical vector, specifying the beginning and end of the
pre-disturbance time period for the disturbed time-series that defines
the baseline. Obligatory if (\code{b = "d"}), see 'Details'.}

\item{vd_i}{a numeric vector containing the state variable in the
disturbed system or a string specifying the name of the column
containing said variable in the dataframe provided in \code{d_data}.}

\item{td_i}{a numeric vector containing the time or a string specifying the
name of the column containing the time in the dataframe provided
in \code{d_data}.}

\item{d_data}{an optional data frame containing the time series of the
state variable values in a disturbed system.}

\item{vb_i}{an optional numeric vector containing the state variable in
the baseline, or a string for the name of the column in \code{b_data}
containing said variable in the dataframe with baseline values.}

\item{tb_i}{an optional numeric vector containing the time period over which
the baseline was measured, or a string for the name of the column in
\code{b_data} containing said the time variable in the dataframe
with baseline values.}

\item{b_data}{an optional data frame containing the time series of the
state variable values in the baseline.}

\item{comm_d}{a data frame containing long format community data
(species as columns over time as rows) to calculate compositional metrics.}

\item{comm_b}{a data frame containing long format community data (species
names as columns over time as rows) to calculate compositional metrics.}

\item{comm_t}{the name of the time variable in comm_b and comm_d.}

\item{method}{a string identifying the dissimilarity index to be used to
calculate dissimilarity. For more options, see \code{?vegdist}.
Defaults to "bray".}

\item{binary}{a boolean stating whether presence/absence standardization
should be performed before calculating the dissimilarity. For more options,
see \code{?vegdist}. Defaults to "bray".}

\item{na_rm}{a logical determining whether NAs should be taken out prior
to the estimation of the stability metric. Defaults to TRUE.}
}
\value{
A numeric, the rate of recovery. If
\eqn{R_r = 0}
, the system did not react to the disturbance.
If
\eqn{R_r \ge 0}
, the system moved towards the values in the baseline after the disturbance
(recovery may be partial).
If
\eqn{Rr \le 0}
, the system deviated even further from the control.
In both cases, the higher
\eqn{R_r}
, the faster the response.
}
\description{
\code{recovery_rate} ( \eqn{R_r} ) returns the rate of recovery calculated as
the slope of a linear model which uses the time as a predictor of the
response. The response can be the state variable in a disturbed system, the
log-response ratio or community dissimilarity between the state variable
(or community) in the disturbed and baseline systems.
The baseline can be
\itemize{
\item a value at time \code{t_rec} of the baseline time-series
\code{b_data} (if \code{b = "input"}).
\item pre-disturbance values of the state variable in the disturbed system
over a period defined by \code{b_tf} (if \code{b = "d"}). In that case,
the state variable is summarized as the mean or median (\code{summ_mode}).
}
}
\details{
For functional stability, the response can the be state variable
itself
( \eqn{v_d} )
, or the log-response ratio between the
state variable in the disturbed ( \eqn{v_d} ) and in the
baseline ( \eqn{v_b} or \eqn{v_p} if the baseline is pre-disturbance values).
For community stability, the response is the dissimilarity between the
disturbed ( \eqn{C_d} ) and baseline ( \eqn{C_b} ) communities. Therefore,

\deqn{
R_r =
\frac{\sum (t - \bar{t})(y - \bar{y})}{
      \sum (t - \bar{t})^2},
\qquad
y \in \left\{
  v_d,\;
  \log\!\left(\frac{v_d}{v_b}\right),\;
  \log\!\left(\frac{v_d}{v_p}\right),\;
  \mathrm{dissim}\!\left(\frac{C_d}{C_b}\right)
\right\}
}
}
\examples{
recovery_rate(
  type = "functional", vd_i = "statvar_db", td_i = "time", response = "v",
  d_data = aquacomm_resps, b = "d", metric_tf = c(12, 50)
)
recovery_rate(
  type = "functional", vd_i = "statvar_db", td_i = "time", response = "v",
  d_data = aquacomm_resps, b = "input", metric_tf = c(12, 50),
  vb_i = "statvar_bl", tb_i = "time", b_data = aquacomm_resps
)
recovery_rate(
  type = "compositional", metric_tf = c(0.14, 28), comm_d = comm_dist,
  comm_b = comm_base, comm_t = "time"
)
}
