% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energyGOF.R
\name{inverse_gaussian_dist}
\alias{inverse_gaussian_dist}
\alias{invgauss_dist}
\title{Create an inverse Gaussian distribution object for energy testing}
\usage{
inverse_gaussian_dist(mean = NULL, shape = NULL)

invgauss_dist(mean = NULL, shape = NULL)
}
\arguments{
\item{mean}{NULL or a positive mean parameter}

\item{shape}{NULL or a positive shape parameter}
}
\value{
S3 data object containing the following fields.
\itemize{
\item \code{name}: String
\item \code{composite_p}: Composite predicate. TRUE if test is composite.
\item \code{par}: Distribution parameters, list of the formals.
\item \code{sampler_par}: Distribution parameters used for the calculation of energy
statistic. These may be different than \code{par}.
\item \code{par_domain}: Function used to ensure \code{par} and \code{sampler_par} are valid for
this distribution
\item \code{support}: Function to check that data \code{x} can be tested against \code{y}
\item \code{sampler}: Function used for rng by \code{\link[boot:boot]{boot::boot()}}
\item \code{EYY}: Function to compute \eqn{E|Y-Y'|} (or \eqn{E|Y-Y'|^{pow}}, for the
generalized test.)
\item \code{EXYhat}: Function to compute \eqn{\frac{1}{n} \sum_i E|x_i - Y|} (or
\eqn{\frac{1}{n} \sum_i E|x_i - Y|^{pow}}), where Y is distributed according
to \code{y} and x is the data under test (which is passed in \code{egof.test} or \code{egofd}).
\item \code{xform}: Function that may be used to transform x. Only available in certain
distribution objects.
\item \code{statistic}: Function that returns a list of maximum likelihood estimates.
Only available in certain distribution objects.
\item \code{notes}: Distribution specific messages. Only used in certain distribution
objects.
}

\emph{Note}: Some distributions do not have notes, xform, and statistic fields.
This is because either a composite test is not implemented, or because a
data transformation is not needed.
}
\description{
Create an S3 object that sets all the required data needed by
energyGOFdist to execute the energy goodness-of-fit test against an inverse
Gaussian distribution. If \code{mean} and \code{shape} are both NULL, perform a
composite test. This is exactly the distribution corresponding to the PDF

\deqn{
  f(x | \mu, \lambda) =
  \left( \frac{\lambda}{2 \pi x^3} \right)^{1/2}
  \exp \left( -\frac{\lambda (x - \mu)^2}{2 \mu^2 x} \right),
  \qquad x > 0,
}

where \code{mean} is \eqn{\mu} and \code{shape} is \eqn{\lambda}.
}
\details{
This distribution requires an intense amount of numerical integration for
the simple (known parameters) case, and the implementation seems to be fine
for samples up to 1000. For the composite case, the data are transformed to
a Chi-squared distribution (conditional on the parameter estimates), and the
performance is much better, as there is no numerical integration in this
case.
}
\examples{
d <- inverse_gaussian_dist(4, 4)
x <- d$sampler(10, d$par)

egofd(x, d, 0)

}
\author{
John T. Haman
}
