% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site.R
\docType{data}
\name{site}
\alias{site}
\title{Forest Site Information Dataset (site)}
\format{
A data frame with 209 rows and 5 columns:
\describe{
  \item{PlotID}{Unique identifier for each forest plot (e.g., "FIN01", "FIN02")}
  \item{Country}{Country where the plot is located (e.g., "Finland", "Germany", "Italy", "Poland", "Romania", "Spain")}
  \item{RestrictedSpeciesRichness}{The restricted/realized tree species richness in the plot (integer values typically ranging from 1 to 5)}
  \item{Composition}{Species composition code indicating the tree species present in the plot. Species abbreviations follow a standardized format (e.g., "Piab.Pisy" for Picea abies and Pinus sylvestris, "Be.Piab" for Betula spp. and Picea abies)}
  \item{coniferous}{Proportion of coniferous trees in the plot, ranging from 0 (purely broadleaved) to 1 (purely coniferous). This represents the relative dominance of coniferous versus broadleaved species}
}
}
\source{
Baeten, L., Verheyen, K., Wirth, C., Bruelheide, H., Bussotti, F., Finér, L., Jaroszewicz B., et al. 2013.
A novel comparative research platform designed to determine the functional significance of tree species
diversity in European forests. Perspectives in Plant Ecology, Evolution and Systematics 15(5): 281–291.

Manning, P., van der Plas, F., Soliveres, S., Allan, E., Maestre, F. T., Mace, G., Whittingham, M., J.,
and Fischer, M. 2018. Redefining ecosystem multifunctionality. Nature Ecology & Evolution 2: 427–436

Scherer-Lorenzen, M., Allan, E., Ampoorter, E., Avacaritiei, D., Baeten, L., Barnoaiea, I., Bastias,
C. C., et al. 2023. The functional significance of tree species diversity in European forests—the
FunDivEUROPE dataset. Dryad Digital Repository.
}
\usage{
site
}
\description{
A dataset containing site-level information for 209 forest plots across the FunDivEUROPE Exploratory Platform. This dataset provides essential metadata about plot location, species composition, and forest type characteristics that are used as explanatory variables in biodiversity-ecosystem function analyses.
}
\examples{
data(site)
head(site)
}
\keyword{datasets}
