#' Forest Functions Dataset (functions)
#'
#' @description
#' A dataset containing 11 ecosystem functions measured across the FunDivEUROPE Exploratory Platform. This dataset represents the core ecosystem functions selected for multifunctionality analysis, focusing on variables that represent stocks of energy or matter, or process rates showing the transfer of these materials between ecosystem compartments.
#'
#' @format A data frame with 209 rows and 11 columns:
#' \describe{
#'   \item{productivity}{Annual aboveground wood production/timber production}
#'   \item{biomass}{Aboveground tree biomass}
#'   \item{wood_decomposition}{Decomposition rate of wooden materials}
#'   \item{litter_decomposition_all}{Decomposition rate of leaf litter}
#'   \item{total_soil_C}{Total soil carbon stocks}
#'   \item{total_soil_N}{Total soil nitrogen stocks}
#'   \item{root_biomass}{Total biomass of living fine roots}
#'   \item{NC}{Soil C:N ratio (calculated from total soil carbon and nitrogen)}
#'   \item{insect_herbivory}{Insect herbivory damage rate}
#'   \item{browser_herbivory}{Mammal browsing damage rate}
#'   \item{pathogen_activity}{Pathogen damage rate}
#' }
#'
#' @source
#' Baeten, L., Verheyen, K., Wirth, C., Bruelheide, H., Bussotti, F., Finér, L., Jaroszewicz B., et al. 2013.
#' A novel comparative research platform designed to determine the functional significance of tree species
#' diversity in European forests. Perspectives in Plant Ecology, Evolution and Systematics 15(5): 281–291.
#'
#' Manning, P., van der Plas, F., Soliveres, S., Allan, E., Maestre, F. T., Mace, G., Whittingham, M., J.,
#' and Fischer, M. 2018. Redefining ecosystem multifunctionality. Nature Ecology & Evolution 2: 427–436
#'
#' Scherer-Lorenzen, M., Allan, E., Ampoorter, E., Avacaritiei, D., Baeten, L., Barnoaiea, I., Bastias,
#' C. C., et al. 2023. The functional significance of tree species diversity in European forests—the
#' FunDivEUROPE dataset. Dryad Digital Repository.
#'
#' @examples
#' data(functions)
#' head(functions)
"functions"
