% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_cart.R
\name{step_collapse_cart}
\alias{step_collapse_cart}
\alias{tidy.step_collapse_cart}
\title{Supervised Collapsing of Factor Levels}
\usage{
step_collapse_cart(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  outcome = NULL,
  cost_complexity = 1e-04,
  min_n = 5,
  results = NULL,
  skip = FALSE,
  id = rand_id("step_collapse_cart")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \link[recipes:selections]{recipes::selections} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{outcome}{A call to \code{vars} to specify which variable is used as the
outcome to train CART models in order to pool factor levels.}

\item{cost_complexity}{A non-negative value that regulates the complexity of
the tree when pruning occurs. Values near 0.1 usually correspond to a tree
with a single splits. Values of zero correspond to unpruned tree.}

\item{min_n}{An integer for how many data points are required to make further
splits during the tree growing process. Larger values correspond to less
complex trees.}

\item{results}{A list of results to convert to new factor levels.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\link[recipes:bake]{recipes::bake}? While all operations are baked when \link[recipes:prep]{recipes::prep} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated recipe step.
}
\description{
\code{step_collapse_cart()} creates a \emph{specification} of a recipe step that can
collapse factor levels into a smaller set using a supervised tree.
}
\details{
This step uses a CART tree (classification or regression) to group the
existing factor levels into a potentially smaller set. It changes the levels
in the factor predictor (and the \code{tidy()} method can be used to understand
the translation).

There are a few different ways that the step will not be able to collapse
levels. If the model fails or, if the results have each level being in its
own split, the original factor levels are retained. There are also cases
where there is "no admissible split" which means that the model could not
find any signal in the data.
}
\section{Tidying}{
When you \code{\link[recipes:tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{old}, \code{new}, and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{old}{character, the old levels}
\item{new}{character, the new levels}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed(c("modeldata", "rpart"))) withAutoprint(\{ # examplesIf}
data(ames, package = "modeldata")
ames$Sale_Price <- log10(ames$Sale_Price)

rec <-
  recipe(Sale_Price ~ ., data = ames) |>
  step_collapse_cart(
    Sale_Type, Garage_Type, Neighborhood,
    outcome = vars(Sale_Price)
  ) |>
  prep()
tidy(rec, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=step_collapse_stringdist]{step_collapse_stringdist()}}
}
