% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turns.R
\name{Turn}
\alias{Turn}
\alias{UserTurn}
\alias{SystemTurn}
\alias{AssistantTurn}
\title{A user, assistant, or system turn}
\usage{
Turn(role = NULL, contents = list(), tokens = NULL)

UserTurn(contents = list())

SystemTurn(contents = list())

AssistantTurn(
  contents = list(),
  json = list(),
  tokens = c(NA_real_, NA_real_, NA_real_),
  cost = NA_real_,
  duration = NA_real_
)
}
\arguments{
\item{role}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
For system, user and assistant turns, use \code{SystemTurn()}, \code{UserTurn()}, and
\code{AssistantTurn()}, respectively.}

\item{contents}{A list of \link{Content} objects.}

\item{tokens}{A numeric vector of length 3 representing the number of
input tokens (uncached), output tokens, and input tokens (cached)
used in this turn.}

\item{json}{The serialized JSON corresponding to the underlying data of
the turns. This is useful if there's information returned by the provider
that ellmer doesn't otherwise expose.}

\item{cost}{The cost of the turn in dollars.}

\item{duration}{The duration of the request in seconds.}
}
\value{
An S7 \code{Turn} object

An S7 \code{AssistantTurn} object
}
\description{
Every conversation with a chatbot consists of pairs of user and assistant
turns, corresponding to an HTTP request and response. These turns are
represented by the \code{Turn} object, which contains a list of \link{Content}s representing
the individual messages within the turn. These might be text, images, tool
requests (assistant only), or tool responses (user only).

\code{UserTurn}, \code{AssistantTurn}, and \code{SystemTurn} are specialized subclasses
of \code{Turn} for different types of conversation turns. \code{AssistantTurn} includes
additional metadata about the API response.

Note that a call to \verb{$chat()} and related functions may result in multiple
user-assistant turn cycles. For example, if you have registered tools,
ellmer will automatically handle the tool calling loop, which may result in
any number of additional cycles. Learn more about tool calling in
\code{vignette("tool-calling")}.
}
\examples{
UserTurn(list(ContentText("Hello, world!")))
}
