% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{ddirmult}
\alias{ddirmult}
\title{Dirichlet-multinomial}
\usage{
ddirmult(x, prob, ln_theta, log = TRUE)
}
\arguments{
\item{x}{numeric vector of observations across categories}

\item{prob}{numeric vector of category probabilities}

\item{ln_theta}{logit-ratio of effective and input sample size}

\item{log}{whether to return the log-probability or not}
}
\value{
The log-likelihood resulting from the Dirichlet-multinomial distribution
}
\description{
Allows data-weighting as parameter
}
\examples{
library(RTMB)
prob = rep(0.1,10)
x = rmultinom( n=1, prob=prob, size=20 )[,1]
f = function( ln_theta ) ddirmult(x, prob, ln_theta)
f( 0 )
F = MakeTape(f, 0)
F$jacfun()(0)

}
