% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_var.R
\name{plot_var}
\alias{plot_var}
\title{Visualize Covariate Distribution Across TG, VCG, and POOL}
\usage{
plot_var(data, what = NULL, stratum = "in_stratum", group = "VCG", title = "")
}
\arguments{
\item{data}{A balanced data frame (output of the VCG_sampler function)}

\item{what}{A string specifying the name of the variable to be visualized.}

\item{stratum}{A string specifying the name of the stratum variable (default is `"in_stratum"`)}

\item{group}{A string specifying the column name used to define group membership (default is `"VCG"`).}

\item{title}{Optional title for the plot.}
}
\value{
A ggplot2 object showing either:
\itemize{
  \item A boxplot for continuous variables (more than 4 unique values).
  \item A proportional bar chart for categorical variables (2–4 unique values).
}
}
\description{
Creates a plot to compare the distribution of a selected variable across three groups:
TG (treated groups), VCG (virtual control group), and POOL (data pool).
}
\details{
The function uses energy distance to quantify distributional differences between groups.
For continuous variables, it overlays dashed lines for TG group statistics (mean, min, max) and displays sample sizes.
For categorical variables, it uses color-coded bars and cumulative proportion lines to highlight imbalance.
}
\examples{

dat   <- data.frame(
  cov1  = rnorm(50, 10, 1),
  cov2  = rnorm(50, 7,  1),
  cov3  = rnorm(50, 5,  1),
  treated = rep(c(0, 1), c(35, 15))
)
  out <- VCG_sampler(treated ~ cov1 + cov2 + cov3, data=dat, n=5, plot=FALSE)
  plot_var(out, what='cov1', group='VCG')
  plot_var(out, what='cov2', group='VCG')

}
