% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite.R
\name{ls_unite}
\alias{ls_unite}
\title{Unite Columns of a Table in a \code{list} of \code{data.frame}.}
\usage{
ls_unite(adam_db, tab, cols, sep = ".", new = NULL)
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) to be transformed.}

\item{tab}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{cols}{(\code{character}) the name of the columns to unite.}

\item{sep}{(\code{string}) the separator for the new column name.}

\item{new}{(\code{string}) the name of the new column. If \code{NULL} the concatenation of \code{cols} separated by \code{sep} is used.}
}
\value{
\code{list} of \code{data.frames} object with a united column.
}
\description{
Unite Columns of a Table in a \code{list} of \code{data.frame}.
}
\examples{
db <- list(mtcars = mtcars, iris = iris)

x <- ls_unite(db, "mtcars", c("mpg", "hp"), new = "FUSION")
x$mtcars
}
