% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{create_SCNA_score_df}
\alias{create_SCNA_score_df}
\title{Create SCNA Score Data Frame}
\usage{
create_SCNA_score_df(
  scna_genes_df,
  build = "GRCh37",
  log2_ratio_threshold = 0.25,
  MCR_overlap_threshold = 25
)
}
\arguments{
\item{scna_genes_df}{data frame of gene-level SCNAs (can be output of \code{\link{create_gene_level_scna_df}})}

\item{build}{genome build for the SCNA segments data frame (default = 'GRCh37')}

\item{log2_ratio_threshold}{the \ifelse{html}{\out{log<sub>2</sub>}}{\eqn{log_2}}
ratio threshold for keeping high-confidence SCNA events (default = 0.25)}

\item{MCR_overlap_threshold}{the percentage threshold for the overlap between
a gene and an MCR region (default = 25). This means that if only a gene
overlaps an MCR region more than this threshold, the gene is assigned the
SCNA density of the MCR}
}
\value{
data frame of SCNA proxy scores containing 2 columns: \describe{
\item{gene_symbol}{HGNC gene symbol}
\item{SCNA_density}{SCNA proxy score. SCNA density (SCNA/Mb) of the minimal common region (MCR) in which the gene is located.}
}
}
\description{
Create SCNA Score Data Frame
}
\details{
The function first aggregates SCNA \ifelse{html}{\out{log<sub>2</sub>}}{\eqn{log_2}} ratio
on gene-level (by keeping the ratio with the maximal \ifelse{html}{\out{|log<sub>2</sub>|}}{\eqn{|log_2|}}
ratio over all the SCNA segments overlapping a gene). Next, it identifies the
minimal common regions (MCRs) that the genes overlap and finally assigns the
SCNA density (SCNA/Mb) values as proxy SCNA scores.
}
