% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flame.R
\name{flame}
\alias{flame}
\title{Display an Animated Flame Visualization}
\usage{
flame(
  intensity = 50,
  flameGradientColors = c("white", "yellow", "darkred"),
  flameOutline = "darkred",
  bgcol = "white",
  width = NULL,
  height = NULL
)
}
\arguments{
\item{intensity}{Numeric value controlling the size of the flame. Values greater than 100
cause the flame to grow beyond default scaling, while smaller values shrink it.
Defaults to 50.}

\item{flameGradientColors}{A length-3 character vector specifying the colors of the flame gradient,
from the center outward. Defaults to \code{c("white", "yellow", "darkred")}.}

\item{flameOutline}{Color string for the flame's outline stroke. Defaults to "darkred".}

\item{bgcol}{Background color of the SVG canvas. Defaults to "white".}

\item{width}{Optional width of the SVG output.}

\item{height}{Optional height of the SVG output.}
}
\value{
An \code{r2d3} object displaying the animated flame visualization.
}
\description{
Creates an animated flame SVG visualization whose size and color gradient
can be customized. The flame grows or shrinks based on the intensity parameter,
with smooth pulsing and wobbling animation.
}
\examples{
flame(intensity = 5)
flame(
  intensity = 50,
  flameGradientColors = c("lightblue", "blue", "darkblue")
)
}
