% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{CreateBacktestSpecification}
\alias{CreateBacktestSpecification}
\title{Create a list describing backtest parameters}
\usage{
CreateBacktestSpecification(
  index,
  gapDuration,
  validationStartDate,
  validationDuration
)
}
\arguments{
\item{index}{integer. The index of the backtest}

\item{gapDuration}{character. The desired duration of the gap
between training and validation data for the backtest in duration format (ISO8601).}

\item{validationStartDate}{character. The desired start date of the validation data
for this backtest (RFC 3339 format).}

\item{validationDuration}{character. The desired end date
of the validation data for this backtest in duration format (ISO8601).}
}
\value{
list with backtest parameters
}
\description{
Uniquely defines a Backtest used in a DatetimePartitioning
}
\details{
Includes only the attributes of a backtest directly controllable by users.  The other attributes
are assigned by the DataRobot application based on the project dataset and the user-controlled
settings.
All durations should be specified with a duration string such as those returned
by the ConstructDurationString helper function.
}
\examples{
zeroDayDuration <- ConstructDurationString()
hundredDayDuration <- ConstructDurationString(days = 100)
CreateBacktestSpecification(index = 0,
                            gapDuration = zeroDayDuration,
                            validationStartDate = "1989-12-01",
                            validationDuration = hundredDayDuration)
}
