% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.rdepth.r
\name{gl.filter.rdepth}
\alias{gl.filter.rdepth}
\title{Filters loci based on counts of sequence tags scored at a locus (read
 depth)
 @family matched filter}
\usage{
gl.filter.rdepth(
  x,
  lower = 5,
  upper = 1000,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or tag
presence/absence data [required].}

\item{lower}{Lower threshold value below which loci will be removed
[default 5].}

\item{upper}{Upper threshold value above which loci will be removed
[default infinite=1000].}

\item{plot.display}{If TRUE, histograms of base composition are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5", "#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory in which to save files [default = working directory]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default 2, unless specified using gl.set.verbosity].}
}
\value{
Returns a genlight object retaining loci with a Read Depth in the
range specified by the lower and upper threshold.
}
\description{
SNP datasets generated by DArT report AvgCountRef and AvgCountSnp as counts
of sequence tags for the reference and alternate alleles respectively. These
can be used to back calculate Read Depth. Fragment presence/absence datasets
as provided by DArT (SilicoDArT) provide Average Read Depth and Standard
 Deviation of Read Depth as standard columns in their report.
Filtering on Read Depth using the companion script gl.filter.rdepth can be on
 the basis of loci with exceptionally low counts,
or loci with exceptionally high counts.
}
\details{
For examples of themes, see:
 \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\examples{
 \donttest{
# SNP data
  gl.report.rdepth(testset.gl)
  result <- gl.filter.rdepth(testset.gl, lower=8, upper=50, verbose=3)
# Tag P/A data
  result <- gl.filter.rdepth(testset.gs, lower=8, upper=50, verbose=3)
  }
  res <- gl.filter.rdepth(platypus.gl)
}
\seealso{
\code{\link{gl.filter.rdepth}}
}
\author{
Custodian: Arthur Georges (Post to
\url{https://groups.google.com/d/forum/dartr})
}
