% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_splines_plot.R
\name{cp_splines_plot}
\alias{cp_splines_plot}
\title{Plot penalized smoothing splines from \code{cpobj} object}
\usage{
cp_splines_plot(cpobj, show_splines = TRUE, adj_splines = TRUE)
}
\arguments{
\item{cpobj}{list, contains variables for pspline plot:
\itemize{
\item \code{nb_of_cp} (number of cutpoints)
\item \code{cp} (contain one or two cutpoint/s)
\item \code{dp} (digits for plot)
\item \code{cpvarname} (name of the variable for that the cutpoints are estimated)
\item \code{cpdata} a data frame, contains the following variables: a variable that is
dichotomized, \code{time} (follow-up time), \code{even}t (status indicator),
\code{covariates} (a vector with the names of the covariates and/or factors))
}}

\item{show_splines}{logical, if \code{TRUE}, The plot shows splines with
different degrees of freedom. This may help determine whether
misspecification or overfitting occurs.}

\item{adj_splines}{logical, if \code{TRUE}, the splines are adjusted for the
covariates. Default is \code{TRUE}.}
}
\value{
Plots penalized smoothing splines and shows the cutpoints.
}
\description{
Create penalized smoothing splines plot with different degrees
of freedom and shows the cutpoints of the dichotomised variable.
}
\examples{
cpvar <- rnorm(100, mean = 100, sd = 10)
time <- seq(1, 100, 1)
event <- rbinom(100, 1, 0.5)
datf <- data.frame(time, event, cpvar)
plot_splines_list <- list(cpdata = datf, nb_of_cp = 1, cp = 95, dp = 2,
    cpvarname = "Biomarker")
cp_splines_plot(plot_splines_list)
}
\seealso{
\code{\link[=cp_est]{cp_est()}} for main function of the package, \code{\link[=cp_value_plot]{cp_value_plot()}}
for Value plots and Index plots
}
