% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence_tests.R
\name{test_cointegration_control}
\alias{test_cointegration_control}
\title{Classical cointegration control (Johansen trace or eigen)}
\usage{
test_cointegration_control(
  factors_data,
  max_lag = 4,
  type = "trace",
  ecdet = "const",
  verbose = TRUE
)
}
\arguments{
\item{factors_data}{A list with matrices \code{scores_X} and \code{scores_Y}
(T x Kx) and (T x Ky), respectively.}

\item{max_lag}{Integer; maximum lag \code{K} passed to \code{urca::ca.jo()}.}

\item{type}{Character; Johansen test type, one of \code{"trace"} or
\code{"eigen"}. Defaults to \code{"trace"}.}

\item{ecdet}{Character; deterministic terms, e.g. \code{"const"},
\code{"trend"}, or \code{"none"}. Defaults to \code{"const"}.}

\item{verbose}{Logical; print progress and a summary of the test. Default \code{TRUE}.}
}
\value{
A list with:
\itemize{
\item \code{test}: the \code{urca::ca.jo} fitted object,
\item \code{n_coint}: integer number of cointegrating relations at 5\%,
\item \code{vectors}: matrix of cointegrating vectors (or \code{NULL} if none).
}
}
\description{
Runs Johansen's cointegration test on the first min(2, ncol(X), ncol(Y))
factors from \code{scores_X} and \code{scores_Y}, and counts the number of
cointegrating relations at the 5\% level.
}
\details{
This function requires the optional package \pkg{urca} (declared in
\code{Suggests}). It does not attempt to install packages at runtime; if
\pkg{urca} is unavailable, an informative error is thrown.

The 5\% critical values are taken from the \code{"5pct"} column of the
\code{cval} slot returned by \code{urca::ca.jo()}.
}
\examples{
\donttest{
if (requireNamespace("urca", quietly = TRUE)) {
  set.seed(1)
  T <- 120
  X <- cbind(cumsum(rnorm(T)), cumsum(rnorm(T)))
  Y <- cbind(cumsum(rnorm(T)), cumsum(rnorm(T)))
  fd <- list(scores_X = X, scores_Y = Y)
  out <- test_cointegration_control(fd, max_lag = 2, verbose = FALSE)
  str(out)
}
}
}
\references{
Johansen, S. (1991). Estimation and Hypothesis Testing of Cointegration Vectors
in Gaussian Vector Autoregressive Models. \emph{Econometrica}, 59(6), 1551-1580.

Johansen, S. (1995). \emph{Likelihood-Based Inference in Cointegrated Vector
Autoregressive Models}. Oxford University Press.
}
\seealso{
\code{\link[urca]{ca.jo}}
}
