% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citation_analysis.R
\name{analyze_scientific_content}
\alias{analyze_scientific_content}
\title{Enhanced scientific content analysis with citation extraction}
\usage{
analyze_scientific_content(
  text,
  doi = NULL,
  mailto = NULL,
  citation_type = c("all", "numeric_superscript", "numeric_bracketed", "author_year"),
  window_size = 10,
  min_word_length = 3,
  remove_stopwords = TRUE,
  language = "en",
  custom_stopwords = NULL,
  ngram_range = c(1, 3),
  parse_multiple_citations = TRUE,
  use_sections_for_citations = "auto",
  n_segments_citations = 10
)
}
\arguments{
\item{text}{Character string or named list. Document text or text with sections.}

\item{doi}{Character string or NULL. DOI for CrossRef reference retrieval.}

\item{mailto}{Character string or NULL. Email for CrossRef API.}

\item{citation_type}{Character string. Type of citations to extract:
\itemize{
\item "all": Extract all citation types (default)
\item "numeric_superscript": Only numeric citations (brackets and superscript) + narrative
\item "numeric_bracketed": Only bracketed numeric citations + narrative
\item "author_year": Only author-year citations + narrative
}}

\item{window_size}{Integer. Words before/after citations for context (default: 10).}

\item{min_word_length}{Integer. Minimum word length for analysis (default: 3).}

\item{remove_stopwords}{Logical. Remove stopwords (default: TRUE).}

\item{language}{Character. Language for stopwords (default: "en").}

\item{custom_stopwords}{Character vector. Additional stopwords.}

\item{ngram_range}{Integer vector. N-gram range, e.g. c(1,3) (default: c(1,3)).}

\item{parse_multiple_citations}{Logical. Parse complex citations (default: TRUE).}

\item{use_sections_for_citations}{Logical or "auto". Use sections for mapping (default: "auto").}

\item{n_segments_citations}{Integer. Segments if not using sections (default: 10).}
}
\value{
List with class "enhanced_scientific_content_analysis" containing:
\itemize{
\item text_analytics: Basic statistics and word frequencies
\item citations: All extracted citations with metadata
\item citation_contexts: Citations with surrounding text
\item citation_metrics: Citation type distribution, density, etc.
\item citation_references_mapping: Matched citations to references
\item parsed_references: Structured reference list
\item word_frequencies: Word frequency table
\item ngrams: N-gram frequency tables
\item network_data: Citation co-occurrence data
\item summary: Overall analysis summary
}
}
\description{
Comprehensive analysis of scientific documents including citation extraction,
reference matching, text analysis, and bibliometric indicators.
}
\details{
This function performs:
\itemize{
\item Citation extraction (numbered, author-year, narrative, parenthetical)
\item Reference parsing (from text or CrossRef API)
\item Citation-reference matching
\item Text analysis (word frequencies, n-grams)
\item Citation context extraction
\item Bibliometric indicators
}

The citation_type parameter filters which citation patterns to search for,
reducing false positives. Narrative citations are always included as they
are context-dependent.
}
\examples{
\dontrun{
# For documents with numeric citations
doc <- pdf2txt_auto("paper.pdf", citation_type = "numeric_bracketed")
analysis <- analyze_scientific_content(
  doc,
  citation_type = "numeric_bracketed",
  doi = "10.xxxx/xxxxx",
  mailto = "your@email.com"
)

# For documents with author-year citations
doc <- pdf2txt_auto("paper.pdf", citation_type = "author_year")
analysis <- analyze_scientific_content(
  doc,
  citation_type = "author_year"
)

summary(analysis)
head(analysis$citations)
table(analysis$citation_metrics$type_distribution)
}

}
