% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getBlockedArm}
\alias{getBlockedArm}
\title{Get Blocked Arm}
\usage{
getBlockedArm(numsubjects, num.per.block, prob = NULL)
}
\arguments{
\item{numsubjects}{Number of subjects to randomize.}

\item{num.per.block}{Number from each arm per block. Block size is 'sum(num.per.block)'.}

\item{prob}{Probability of randomization to each arm. Default assumes equal probability.}
}
\value{
Return vector of arm allocations.
}
\description{
Randomize patients to arms using blocked randomization.
}
\details{
To balance covariates, each block gets an equal distribution of treatment arms to remove the effect
that could come from the block characteristics (e.g. covariates). If not balancing covariates,
patients will be randomized according to ratios.
}
\examples{
arm <- getBlockedArm(500, c(1,1))
}
