% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comparator.R, R/CppSeqComparator.R,
%   R/StringComparator.R, R/NumericComparator.R, R/Chebyshev.R, R/Minkowski.R,
%   R/FuzzyTokenSet.R, R/InVocabulary.R, R/Lookup.R, R/MongeElkan.R
\name{pairwise}
\alias{pairwise}
\alias{pairwise,Comparator,ANY,missing-method}
\alias{pairwise,CppSeqComparator,list,list-method}
\alias{pairwise,CppSeqComparator,list,NULL-method}
\alias{pairwise,StringComparator,vector,vector-method}
\alias{pairwise,StringComparator,vector,NULL-method}
\alias{pairwise,NumericComparator,matrix,vector-method}
\alias{pairwise,NumericComparator,vector,matrix-method}
\alias{pairwise,Chebyshev,matrix,matrix-method}
\alias{pairwise,Chebyshev,matrix,NULL-method}
\alias{elementwise,Minkowski,matrix,matrix-method}
\alias{pairwise,Minkowski,matrix,matrix-method}
\alias{pairwise,Minkowski,matrix,NULL-method}
\alias{pairwise,FuzzyTokenSet,list,list-method}
\alias{pairwise,FuzzyTokenSet,vector,NULL-method}
\alias{pairwise,InVocabulary,vector,vector-method}
\alias{pairwise,InVocabulary,vector,NULL-method}
\alias{pairwise,Lookup,vector,vector-method}
\alias{pairwise,Lookup,vector,NULL-method}
\alias{pairwise,MongeElkan,list,list-method}
\alias{pairwise,MongeElkan,list,NULL-method}
\title{Pairwise Similarity/Distance Matrix}
\usage{
pairwise(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{Comparator,ANY,missing}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{CppSeqComparator,list,list}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{CppSeqComparator,list,`NULL`}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{StringComparator,vector,vector}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{StringComparator,vector,`NULL`}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{NumericComparator,matrix,vector}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{NumericComparator,vector,matrix}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{Chebyshev,matrix,matrix}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{Chebyshev,matrix,`NULL`}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{elementwise}{Minkowski,matrix,matrix}(comparator, x, y, ...)

\S4method{pairwise}{Minkowski,matrix,matrix}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{Minkowski,matrix,`NULL`}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{FuzzyTokenSet,list,list}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{FuzzyTokenSet,vector,`NULL`}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{InVocabulary,vector,vector}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{InVocabulary,vector,`NULL`}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{Lookup,vector,vector}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{Lookup,vector,`NULL`}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{MongeElkan,list,list}(comparator, x, y, return_matrix = FALSE, ...)

\S4method{pairwise}{MongeElkan,list,`NULL`}(comparator, x, y, return_matrix = FALSE, ...)
}
\arguments{
\item{comparator}{a comparator used to compare the objects, which is a
sub-class of \code{\linkS4class{Comparator}}.}

\item{x, y}{a collection of objects to compare, typically stored as entries
in an atomic vector, rows in a matrix, or entries in a list. The required
format depends on the type of \code{comparator}. \code{y} may be omitted or set to
\code{NULL} to compare objects in \code{x}.}

\item{return_matrix}{a logical of length 1. If FALSE (default), the pairwise
similarities/distances will be returned as a \code{\linkS4class{PairwiseMatrix}}
which is more space-efficient for symmetric comparators. If TRUE, a
standard \code{\link{matrix}} is returned instead.}

\item{...}{other parameters passed on to other methods.}
}
\value{
If both \code{x} and \code{y} are specified, every object in \code{x} is compared with
every object in \code{y} using the comparator, and the resulting scores are
returned in a \code{size(x)} by \code{size(y)} matrix.

If only \code{x} is specified, then the objects in \code{x} are compared with
themselves using the comparator, and the resulting scores are returned in a
\code{size(x)} by \code{size(y)} matrix.

By default, the matrix is represented as an instance of the
\code{\linkS4class{PairwiseMatrix}} class, which is more space-efficient for symmetric
comparators when \code{y} is not specified. However, if \code{return_matrix = TRUE},
the matrix is returned as an ordinary \code{\link{matrix}} instead.
}
\description{
Computes pairwise similarities/distances between two collections of objects
(strings, vectors, etc.) using the provided comparator.
}
\section{Methods (by class)}{
\itemize{
\item \code{comparator = Comparator,x = ANY,y = missing}: Compute a pairwise comparator when \code{y}

\item \code{comparator = CppSeqComparator,x = list,y = list}: Specialization for \code{\linkS4class{CppSeqComparator}} where \code{x}
and \code{y} are lists of sequences (vectors) to compare.

\item \code{comparator = CppSeqComparator,x = list,y = NULL}: Specialization for \code{\linkS4class{CppSeqComparator}} where \code{x} is
a list of sequences (vectors) to compare.

\item \code{comparator = StringComparator,x = vector,y = vector}: Specialization for \code{\linkS4class{StringComparator}} where \code{x}
and \code{y} are vectors of strings to compare.

\item \code{comparator = StringComparator,x = vector,y = NULL}: Specialization for \code{\linkS4class{StringComparator}} where \code{x}
is a vector of strings to compare.

\item \code{comparator = NumericComparator,x = matrix,y = vector}: Specialization for \code{\linkS4class{NumericComparator}} where \code{x}
is a matrix of rows (interpreted as vectors) to compare with a vector \code{y}.

\item \code{comparator = NumericComparator,x = vector,y = matrix}: Specialization for \code{\linkS4class{NumericComparator}} where \code{x}
is a vector to compare with a matrix \code{y} of rows (interpreted as vectors).

\item \code{comparator = Chebyshev,x = matrix,y = matrix}: Specialization for \code{\link{Chebyshev}} where \code{x} and \code{y}
matrices of rows (interpreted as vectors) to compare.

\item \code{comparator = Chebyshev,x = matrix,y = NULL}: Specialization for \code{\link{Minkowski}} where \code{x} is a matrix
of rows (interpreted as vectors) to compare among themselves.

\item \code{comparator = Minkowski,x = matrix,y = matrix}: Specialization for a \code{\link{Minkowski}} where \code{x} and \code{y}
matrices of rows (interpreted as vectors) to compare.

\item \code{comparator = Minkowski,x = matrix,y = matrix}: Specialization for a \code{\link{Minkowski}} where \code{x} and \code{y}
matrices of rows (interpreted as vectors) to compare.

\item \code{comparator = Minkowski,x = matrix,y = NULL}: Specialization for \code{\link{Minkowski}} where \code{x} is a matrix
of rows (interpreted as vectors) to compare among themselves.

\item \code{comparator = FuzzyTokenSet,x = list,y = list}: Specialization for \code{\link{FuzzyTokenSet}} where \code{x} and \code{y} are
lists of token vectors to compare.

\item \code{comparator = FuzzyTokenSet,x = vector,y = NULL}: Specialization for \code{\link{FuzzyTokenSet}} where \code{x} is a list of token
vectors to compare among themselves.

\item \code{comparator = InVocabulary,x = vector,y = vector}: Specialization for \code{\link{InVocabulary}} where \code{x} and \code{y}
are vectors of strings to compare.

\item \code{comparator = InVocabulary,x = vector,y = NULL}: Specialization for \code{\link{InVocabulary}} where \code{x} is a
vector of strings to compare among themselves.

\item \code{comparator = Lookup,x = vector,y = vector}: Specialization for a \code{\link{Lookup}} where \code{x} and \code{y} are
vectors of strings to compare

\item \code{comparator = Lookup,x = vector,y = NULL}: Specialization for \code{\link{Lookup}} where \code{x} is a vector of
strings to compare among themselves

\item \code{comparator = MongeElkan,x = list,y = list}: Specialization for \code{\link{MongeElkan}} where \code{x} and \code{y} are
lists of token vectors to compare.

\item \code{comparator = MongeElkan,x = list,y = NULL}: Specialization for \code{\link{MongeElkan}} where \code{x} is a list
of token vectors to compare among themselves.
}}

\examples{
## Computing the distances between a query point y (a 3D numeric vector) 
## and a set of reference points x
x <- rbind(c(1,0,1), c(0,0,0), c(-1,2,-1))
y <- c(10, 5, 10)
pairwise(Manhattan(), x, y)

## Computing the pairwise similarities among a set of strings
x <- c("Benjamin", "Ben", "Benny", "Bne", "Benedict", "Benson")
comparator <- DamerauLevenshtein(similarity = TRUE, normalize = TRUE)
pairwise(comparator, x, return_matrix = TRUE)  # return an ordinary matrix

}
