% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsv2rgb.R
\name{hsv2rgb}
\alias{hsv2rgb}
\title{hsv to rgb color space}
\usage{
hsv2rgb(h, s, v, maxColorValue = 100)
}
\arguments{
\item{h}{numeric, vector of ‘hue’ values}

\item{s}{numeric, vector of ‘saturation’ values}

\item{v}{numeric, vector of ‘value’ (lightness) values}

\item{maxColorValue}{numeric, default: 100, gives the maximum hsv color values range. Default corresponds to the typical 0:1 HSV coding as in \code{rgb2hsv()}}
}
\value{
unnamed dataframe with rgb colors
}
\description{
Expects hsv color values to be in range (0-100])
}
\examples{
colors <- colorify(5)
rgb <- grDevices::col2rgb(colors)
hsv <- grDevices::rgb2hsv(rgb, maxColorValue = 255)
rgb2 <- hsv2rgb(hsv['h',], hsv['s',], hsv['v',], maxColorValue = 255)
}
