% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_response}
\alias{validate_response}
\title{Validate Argument response}
\usage{
validate_response(df = NULL, response = NULL, quiet = FALSE)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional; character string or vector) Name/s of response variable/s in \code{df}. Used in target encoding when it names a numeric variable and there are categorical predictors, and to compute preference order. Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
character string: response name
}
\description{
Internal function to validate the argument \code{response}. Requires the argument 'df' to be validated with \code{\link[=validate_df]{validate_df()}}.
}
\examples{

data(
  vi
)

#validating example data frame
vi <- validate_df(
  df = vi
)

#validating example predictors
response <- validate_response(
  df = vi,
  response = "vi_numeric"
)

#tagged as validated
attributes(response)$validated

}
\seealso{
Other data_validation: 
\code{\link{validate_data_cor}()},
\code{\link{validate_data_vif}()},
\code{\link{validate_df}()},
\code{\link{validate_encoding_arguments}()},
\code{\link{validate_predictors}()},
\code{\link{validate_preference_order}()}
}
\concept{data_validation}
