% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_coglasso.R
\name{select_coglasso}
\alias{select_coglasso}
\title{Select the best \code{coglasso} network}
\usage{
select_coglasso(
  coglasso_obj,
  method = "xestars",
  stars_thresh = 0.1,
  stars_subsample_ratio = NULL,
  rep_num = 20,
  max_iter = 10,
  old_sampling = FALSE,
  ebic_gamma = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{coglasso_obj}{The object of \code{S3} class \code{coglasso} returned by \code{coglasso()}.}

\item{method}{The model selection method to select the best combination of
hyperparameters. The available options are "xstars", "xestars" and "eBIC".
Defaults to "xestars".}

\item{stars_thresh}{The threshold set for variability of the explored
networks at each iteration of the algorithm. The \eqn{\lambda_w} or the
\eqn{\lambda_b} associated to the most stable network before the threshold
is overcome is selected.}

\item{stars_subsample_ratio}{The proportion of samples in the multi-omics
data set to be randomly subsampled to estimate the variability of the
network under the given hyperparameters setting. Defaults to 80\% when the
number of samples is smaller than 144, otherwise it defaults to
\eqn{\frac{10}{n}\sqrt{n}}.}

\item{rep_num}{The amount of subsamples of the multi-omics data set used to
estimate the variability of the network under the given hyperparameters
setting. Defaults to 20.}

\item{max_iter}{The greatest number of times the algorithm is allowed to
choose a new best \eqn{\lambda_w}. Defaults to 10.}

\item{old_sampling}{Perform the same subsampling \code{xstars()} would if set to
TRUE. Makes a difference with bigger data sets, where computing
a correlation matrix could take significantly longer. Defaults to FALSE.}

\item{ebic_gamma}{The \eqn{\gamma} tuning parameter for \emph{eBIC} selection, to set
between 0 and 1. When set to 0 one has the standard \emph{BIC}. Defaults to 0.5.}

\item{verbose}{Print information regarding the progress of the selection
procedure on the console.}
}
\value{
\code{select_coglasso()} returns an object of \code{S3} class \code{select_coglasso}
containing the results of the
selection procedure, built upon an object of \code{S3} class \code{coglasso}. Some
output elements depend on the chosen model selection method. \cr
These elements are returned by all methods:
\itemize{
\item ... are the same elements returned by \code{\link[=coglasso]{coglasso()}}.
\item \code{sel_index_c}, \code{sel_index_lw} and \code{sel_index_lb} are the indexes of the
final selected parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b}
leading to the most stable sparse network.
\item \code{sel_c}, \code{sel_lambda_w} and \code{sel_lambda_b} are the final selected
parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b} leading to the most
stable sparse network.
\item \code{sel_adj} is the adjacency matrix of the final selected network.
\item \code{sel_density} is the density of the final selected network.
\item \code{sel_icov} is the inverse covariance matrix of the final selected network.
\item \code{sel_cov} optional, given only when \code{coglasso()} was called with
\code{cov_output = TRUE}. It is the covariance matrix associated with the final
selected network.
\item \code{call} is the matched call.
\item \code{method} is the chosen model selection method.
}
These are the additional elements returned when choosing "xestars" or "xstars":
\itemize{
\item \code{merge} is the "merged" adjacency matrix, the average of all the adjacency
matrices estimated across all the different subsamples for the selected
combination of \eqn{\lambda_w}, \eqn{\lambda_b}, and \eqn{c} values in the
last path explored before convergence. Each entry is a measure of how
recurrent the corresponding edge is across the subsamples.
\item \code{variability_lw}, \code{variability_lb} and \code{variability_c} are numeric vectors
of as many items as the number of \eqn{\lambda_w}, \eqn{\lambda_b}, and
\eqn{c} values explored. Each item is the variability of the network
estimated for the corresponding hyperparameter value, keeping the other two
hyperparameters fixed to their selected value.
\item \code{sel_variability} is the variability of the final selected network.
}
These are the additional elements returned when choosing "ebic":
\itemize{
\item \code{ebic_scores} is a numerical vector containing the eBIC scores for all the
hyperparameter combination.
}
}
\description{
\code{select_coglasso()} selects the best combination of hyperparameters given to
\code{coglasso()} according to the selected model selection method. The three
availble options that can be set for the argument \code{method} are  "xstars",
"xestars" and "ebic".
}
\details{
\code{select_coglasso()} provides three model selection strategies:
\itemize{
\item "xstars" uses \emph{eXtended StARS} (\emph{XStARS}) selecting the most stable, yet sparse
network. Stability is computed upon network estimation from multiple subsamples of the
multi-omics data set, allowing repetition. Subsamples are collected for a
fixed amount of times (\code{rep_num}), and with a fixed proportion of the total
number of samples (\code{stars_subsample_ratio}). See \code{\link[=xstars]{xstars()}} for more
information on the methodology.
\item "xestars" uses \emph{eXtended Efficient StARS} (\emph{XEStARS}), a significantly
faster version of \emph{XStARS}. It could produce marginally different results
to "xstars" due to a different sampling strategy. See \code{\link[=xestars]{xestars()}} for
more information on the methodology.
\item "ebic" uses the \emph{extended Bayesian Information}
\emph{Criterion} (\emph{eBIC}) selecting the network that minimizes it. \code{gamma} sets the
wait given to the extended component, turning the model selection method to
the standard \emph{BIC} if set to 0.
}
}
\examples{
cg <- coglasso(multi_omics_sd_micro, p = c(4, 2), nlambda_w = 3, 
               nlambda_b = 3, nc = 3, verbose = FALSE)
# Using eXtended Efficient StARS, takes less than five seconds
sel_cg_xestars <- select_coglasso(cg, method = "xestars", verbose = FALSE)
\donttest{
# Using eXtended StARS, takes around a minute
sel_cg_xstars <- select_coglasso(cg, method = "xstars", verbose = FALSE)
}
# Using eBIC
sel_cg_ebic <- select_coglasso(cg, method = "ebic", verbose = FALSE)

}
