% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cs_anchor_group_between}
\alias{plot.cs_anchor_group_between}
\title{Plot an Object of Class cs_anchor_group_between}
\usage{
\method{plot}{cs_anchor_group_between}(
  x,
  x_lab = "Group",
  y_lab = "Mean Intervention Effect\\n(with 95\%-CI)",
  ...
)
}
\arguments{
\item{x}{An object of class \code{cs_anchor_group_between}}

\item{x_lab}{String, x axis label, defaults to \code{"Group"}}

\item{y_lab}{String, y axis label, defaults to \code{"Mean Intervention Effect (with 95\%-CI)"}}

\item{...}{Additional arguments}
}
\value{
A ggplot2 plot
}
\description{
This function creates a generic group level clinical
significance plot by plotting the between group change with the associated
uncertainty interval around the estimated change on the y-axis.
}
\examples{
cs_results <- antidepressants |>
  cs_anchor(
    patient,
    measurement,
    mom_di,
    mid_improvement = 8,
    target = "group",
    group = condition,
    effect = "between",
    post = "After"
  )


# Plot the results "as is"
plot(cs_results)


# Change the axis labels
plot(cs_results, x_lab = "Condition", y_lab = "Treatment Effect")
}
