% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windrose.R
\name{windrose_days}
\alias{windrose_days}
\title{Windrose (speed/direction) diagram of a station over a days period}
\usage{
windrose_days(
  station,
  start = "2000-12-01",
  end = "2000-12-31",
  n_directions = 8,
  n_speeds = 5,
  speed_cuts = NA,
  col_pal = "GnBu",
  calm_wind = 0,
  legend_title = "Wind Speed (m/s)",
  verbose = FALSE
)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}}) or "all" for all the stations.}

\item{start}{Character string as start date (format: \code{"YYYY-MM-DD"}).}

\item{end}{Character string as end date (format: \code{"YYYY-MM-DD"}).}

\item{n_directions}{Numeric value as the number of direction bins to plot
(petals on the rose). Valid values are \code{4}, \code{8} or \code{16}.}

\item{n_speeds}{Numeric value as the number of equally spaced wind speed
bins to plot. This is used if \code{speed_cuts} is \code{NA} (default \code{5}).}

\item{speed_cuts}{Numeric vector containing the cut points for the wind
speed intervals, or \code{NA} (default).}

\item{col_pal}{Character string indicating the name of the
\code{\link[=hcl.pals]{hcl.pals()}} color palette to be used for plotting.}

\item{calm_wind}{Numeric value as the upper limit for wind speed that is
considered calm (default \code{0}).}

\item{legend_title}{Character string to be used for the legend title.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}
}
\value{
A \CRANpkg{ggplot2} object.
}
\description{
Plot a windrose showing the wind speed and direction for a station over a
days period.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
windrose_days("9434",
  start = "2000-12-01",
  end = "2000-12-31",
  speed_cuts = 4
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=aemet_daily_clim]{aemet_daily_clim()}}

Other aemet_plots: 
\code{\link{climatestripes_station}()},
\code{\link{climatogram_normal}()},
\code{\link{climatogram_period}()},
\code{\link{ggclimat_walter_lieth}()},
\code{\link{ggstripes}()},
\code{\link{ggwindrose}()},
\code{\link{windrose_period}()}

Other wind: 
\code{\link{climaemet_9434_wind}},
\code{\link{ggwindrose}()},
\code{\link{windrose_period}()}
}
\concept{aemet_plots}
\concept{wind}
