% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/before_after_JDay.R
\name{JDay_later}
\alias{JDay_later}
\title{Check whether a Julian date is after another one}
\usage{
JDay_later(check_date, ref_date, season = c(1, 366))
}
\arguments{
\item{check_date}{integer ranging from 1 to 366, indicating a Julian date.
This is the date for which to check whether it is after the reference date.
If this is a vector, all elements are checked against the reference date.}

\item{ref_date}{integer ranging from 1 to 366, indicating a Julian date.
This is the reference date.}

\item{season}{integer vector of length 2, specifying the beginning and end
of the phenology season, respectivcely.}
}
\value{
Boolean result (TRUE/FALSE) of the comparison.
}
\description{
For two Julian dates, this function checks whether the first date
is later than the second date within a user-defined phenological season.
This is particularly useful for seasons that start in one year and end
in the next, because simple > or < operations can produce wrong results
then.
}
\examples{

JDay_later(check_date=10,ref_date=365,season=c(305,59))

}
\author{
Eike Luedeling
}
\keyword{Julian}
\keyword{date}
\keyword{phenology}
\keyword{season}
