% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tamat.R
\name{tamat}
\alias{tamat}
\title{Make a temporal adjacency matrix}
\usage{
tamat(amat, order, type = NULL)
}
\arguments{
\item{amat}{Adjacency matrix.
Row names and column names should be identical and be the names of
the variables/nodes. Variable names should be prefixed with their
period, e.g. "child_x" for variable "x" at period "child"}

\item{order}{A character vector with the periods in their order.}

\item{type}{The type of adjancency matrix, must be one of \code{"pdag"} or
\code{"ag"}. If \code{NULL} (default), the function first checks for a \code{tamat_type}
attribute in the input object and makes sure the output matches that, and if no
the input does not have this attribute, it is set to \code{"tpdag"}. Otherwise,
the user can specify a type manually as follows: \code{"pdag"} should be used for
directed graphs, namely
DAG, CPDAG, MPDAG, TPDAG and PDAG adjacency matrices, i.e. adjacency matrices
where A(i,j) = A(j,i) = 1 is interpreted as an undirected edge. \code{"ag"}
may be used for ADMGs, MAGs, PAGs and TPAGs, where further possible arrowhead
options are available (see \link{amat})}
}
\value{
A \code{tamat} object, which is a matrix with a "order"
attribute(a character vector listing the temporal order of the variables
in the adjacency matrix).
}
\description{
Make a temporal adjacency matrix
}
