% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{rnb}
\alias{rnb}
\title{Simulate from a negative binomial distribution}
\usage{
rnb(n, mean, variance = mean, gamma.variance = NULL)
}
\arguments{
\item{n}{Number of samples (integer)}

\item{mean}{Mean vector (rate parameter)}

\item{variance}{Variance vector}

\item{gamma.variance}{(optional) poisson-gamma mixture parametrization.
Variance (vector) of gamma distribution with mean 1.}
}
\value{
Vector of n realizations
}
\description{
Parametrized by mean (rate) and variance. Both parameters can be
vector arguments. For this case with mean = variance = c(r1, r2) and n = 5,
the returned vector contains 5 Poisson samples. Three samples are drawn from
a Poisson distribution with rate r1 (index 1, 3 and 5 in output vector) and
two from a Poisson with rate r2 (index 2 and 4).
}
\examples{
with(
  data.frame(x = rnb(1e4, mean = 100, var = 500)),
  c(mean = mean(x), var = var(x))
)
}
