% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixDateTimeOriginal.R
\name{fixDateTimeOriginal}
\alias{fixDateTimeOriginal}
\title{Fix DateTimeOriginal Exif metadata tag in Reconyx Hyperfire cameras}
\usage{
fixDateTimeOriginal(inDir, recursive = TRUE)
}
\arguments{
\item{inDir}{character. Name of the directory containing images to be fixed}

\item{recursive}{logical. Recursively find images in subdirectories of
\code{inDir}?}
}
\value{
Returns invisibly the messages returned by the Exiftool call
(warnings etc.).
}
\description{
Some camera models don't store the date/time information in the standard
Exif metadata tag. Consequently, camtrapR cannot find that information. This
function uses Exiftool to update the DateTimeOriginal metadata tag in all
images within a directory to make them readable with camtrapR (and other
software).
}
\details{
Some Reconyx Hyperfire cameras (e.g. HC500) are known to show this problem.
}
\section{Warning }{
 Please make a backup of your images before running this
function.
}

\examples{

\dontrun{
# a hypothetical example

wd_images_hyperfire <- "C:/Some/Directory"

fixDateTimeOriginal(inDir     = wd_images_hyperfire,
                    recursive = TRUE)
}

}
\references{
This function uses the code from: \cr Tobler, Mathias (2015).
Camera Base Version 1.7 User Guide
}
\author{
Juergen Niedballa
}
