% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/christian.R, R/coptic.R,
%   R/lunar_calendars_astronomy.R
\name{advent}
\alias{advent}
\alias{christmas}
\alias{orthodox_christmas}
\alias{epiphany}
\alias{easter}
\alias{orthodox_easter}
\alias{pentecost}
\alias{coptic_christmas}
\alias{astronomical_easter}
\title{Christian Ecclesiastical Holidays}
\usage{
advent(year)

christmas(year)

orthodox_christmas(year)

epiphany(year)

easter(year)

orthodox_easter(year)

pentecost(year)

coptic_christmas(year)

astronomical_easter(year)
}
\arguments{
\item{year}{Gregorian year}
}
\value{
A vector of dates on the Gregorian calendar
}
\description{
Functions to return Gregorian dates for various Christian ecclesiastical holidays and other special days

Coptic Christmas is celebrated on 29th of Koiak in the Coptic calendar, which
currently corresponds to 7 or 8 January in the Gregorian calendar.
}
\examples{
tibble::tibble(
  year = 2025:2030,
  advent = advent(year),
  christmas = christmas(year),
  orthodox_christmas = orthodox_christmas(year),
  epiphany = epiphany(year),
  easter = easter(year),
  orthodox_easter = orthodox_easter(year),
  pentecost = pentecost(year)
)
}
