% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-session-package-installed.R
\name{btw_tool_session_check_package_installed}
\alias{btw_tool_session_check_package_installed}
\title{Tool: Check if a package is installed}
\usage{
btw_tool_session_check_package_installed(package_name, `_intent` = "")
}
\arguments{
\item{package_name}{The name of the package.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
A message indicating whether the package is installed and
its version, or an error indicating that the package is not installed.
}
\description{
Checks if a package is installed in the current session. If the package is
installed, it returns the version number. If not, it suggests packages with
similar names to help the LLM resolve typos.
}
\examples{
btw_tool_session_check_package_installed("dplyr")@value

tryCatch(
  btw_tool_session_check_package_installed("dplry"),
  error = function(err) {
    cat(conditionMessage(err))
  }
)

}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}

Other session tools: 
\code{\link{btw_tool_session_package_info}()},
\code{\link{btw_tool_session_platform_info}()}
}
\concept{session tools}
