% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_performance.R
\name{forecast_poos_recursively.BVARs}
\alias{forecast_poos_recursively.BVARs}
\title{Bayesian recursive pseudo-out-of-sample forecasting}
\usage{
\method{forecast_poos_recursively}{BVARs}(model_spec, poos_spec, show_progress = TRUE)
}
\arguments{
\item{model_spec}{an object of class \code{BVARs} generated using the 
\code{specify_bvars} function and containing the Bayesian VAR models 
specification.}

\item{poos_spec}{an object of class \code{POOSForecastSetup} containing
specification of the recursive pseudo-out-of-sample forecasting exercise 
using expanding window samples.}

\item{show_progress}{a logical value, if \code{TRUE} the estimation progress bar is visible}
}
\value{
An object of class \code{ForecastsPOOS} containing the outcome of Bayesian
 recursive pseudo-out-of-sample forecasting exercise  using expanding window 
 samples. The object is a list with \code{forecasting_sample} elements, where
 \code{forecasting_sample} is equal to the sample size less the maximum of
 \code{horizons} and the \code{training_sample} plus one. Each element of the
 list is an object of class \code{ForecastsPANEL} containing the forecasts for 
 each country, see \code{\link{forecast.PosteriorBVARPANEL}}.
}
\description{
Performs the recursive pseudo-out-of-sample forecasting exercise
using expanding window samples.
}
\examples{
spec = specify_bvars$new(ilo_dynamic_panel[1:5])  # specify the model
poos = specify_poosf_exercise$new(                # specify the forecasting exercise
         spec, 
         S = 5,                                  # use at least S = 5000
         S_burn = 5,                              # use at least S_burn = 1000
         horizons = 1,
         training_sample = 30
       )   
fore = forecast_poos_recursively(spec, poos)      # execute the forecasting exercise

}
\seealso{
\code{\link{forecast.PosteriorBVARPANEL}}, \code{\link{specify_bvarPANEL}},
\code{\link{specify_poosf_exercise}}, \code{\link{estimate.BVARPANEL}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
