% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{relative.effects}
\alias{relative.effects}
\title{Find relative effects for base treatment and comparison treatments}
\usage{
relative.effects(
  result,
  base.treatment = NULL,
  comparison.treatments = NULL,
  base.category = NULL,
  comparison.categories = NULL,
  covariate = NULL
)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{base.treatment}{Base treatment user wants for the relative effects. Base treatment is initially set by \code{Treat.order} parameter in \code{\link{network.data}} (first one in the list). If set to null, default is to use base treatment.}

\item{comparison.treatments}{Treatments that user wants to compare against base treatment. If set to null, all the treatments besides base treatment is considered as comparison treatments.}

\item{base.category}{Base category user wants for the relative effects. Only used for multinomial data.}

\item{comparison.categories}{Category that user wants to compare against base.category. Only used for multinomial data.}

\item{covariate}{Covariate value at which to compute relative effects. Only used if covariate value is specified in the model.}
}
\value{
This returns a mcmc.list sample of relative effects for the base treatment specified. This allows user to obtain relative effects of different base.treatment after the sampling has been done.
For a simple summary, use \code{\link{relative.effects.table}}.
}
\description{
This function calculates relative effects for base treatment and comparison treatments.
}
\examples{
network <- with(parkinsons, {
 network.data(Outcomes, Study, Treat, SE = SE, response = "normal")
})
\donttest{
result <- network.run(network)
summary(relative.effects(result, base.treatment = "Placebo"))
}
}
\seealso{
\code{\link{relative.effects.table}}
}
