#' liquidity Bayesian Network
#'
#'
#' An artificial neural network and Bayesian network model for liquidity risk assessment in banking.
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network demonstrate applicability and exhibit the eﬃciency, accuracy and flexibility of data mining methods when modeling ambiguous occurrences related to bank liquidity risk measurement. Probabilities were given within the referenced paper. The vertices are:
#' \describe{
#' \item{X1}{(FALSE, TRUE);}
#' \item{X2}{(FALSE, TRUE);}
#' \item{X3}{(FALSE, TRUE);}
#' \item{X4}{(FALSE, TRUE);}
#' \item{X5}{(FALSE, TRUE);}
#' \item{X6}{(FALSE, TRUE);}
#' \item{X7}{(FALSE, TRUE);}
#' \item{X8}{(FALSE, TRUE);}
#' \item{X9}{(FALSE, TRUE);}
#' \item{X10}{(FALSE, TRUE);}
#'  }
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @keywords NULL
#' @importClassesFrom bnlearn bn.fit
#' @references Tavana, M., Abtahi, A. R., Di Caprio, D., & Poortarigh, M. (2018). An Artificial Neural Network and Bayesian Network model for liquidity risk assessment in banking. Neurocomputing, 275, 2525-2554.
"liquidity"
