% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_scaling_fun}
\alias{as_scaling_fun}
\title{Scaling function creator}
\usage{
as_scaling_fun(center.col, scale.col, ind.col = seq_along(center.col))
}
\arguments{
\item{center.col}{Vector of centers corresponding to \code{ind.col}.}

\item{scale.col}{Vector of scales corresponding to \code{ind.col}.}

\item{ind.col}{Column indices for which these are provided.}
}
\value{
A function to be used as parameter \code{fun.scaling}.
}
\description{
Convenience function to create a function to be used as parameter \code{fun.scaling}
when you want to use your own precomputed center and scale.
}
\examples{
fun.scaling <- as_scaling_fun(1:6, 2:7)
fun.scaling(NULL, NULL, 1:3)  # first two parameters X and ind.row are not used here
fun.scaling2 <- as_scaling_fun(1:6, 2:7, ind.col = 6:1)
fun.scaling2(NULL, NULL, 1:3)


X <- big_attachExtdata()
sc <- big_scale()(X)
fun <- as_scaling_fun(center = sc$center, scale = sc$scale)
obj.svd <- big_randomSVD(X, fun.scaling = fun)
obj.svd2 <- big_randomSVD(X, fun.scaling = big_scale())
all.equal(obj.svd, obj.svd2)

}
