% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{evaluate_oos}
\alias{evaluate_oos}
\title{Evaluate out-of-sample forecast metrics}
\usage{
evaluate_oos(
  summ,
  Yz,
  Xz,
  zTMG,
  T_train,
  COM_ts,
  K_ts,
  com_in_mean = FALSE,
  horizons = c(1, 4, 8)
)
}
\arguments{
\item{summ}{List. Posterior summary from \code{\link{extract_posterior_summary}}}

\item{Yz}{Numeric matrix. Standardized Y values (T x S)}

\item{Xz}{Numeric matrix. Standardized X values (T x S)}

\item{zTMG}{Numeric vector. Standardized TMG series}

\item{T_train}{Integer. End of training period}

\item{COM_ts}{Numeric matrix. COM values by time and sector (T x S)}

\item{K_ts}{Numeric matrix. Capital values by time and sector (T x S)}

\item{com_in_mean}{Logical. Whether COM is included in mean equation}

\item{horizons}{Integer vector. Forecast horizons to evaluate}
}
\value{
Named list with one element per horizon...
}
\description{
Computes RMSE and MAE for multiple forecast horizons.
}
\examples{
# 1. Generate dummy data for testing
T_obs <- 20
S <- 2
Yz <- matrix(rnorm(T_obs * S), nrow = T_obs, ncol = S)
Xz <- matrix(rnorm(T_obs * S), nrow = T_obs, ncol = S)
COM_ts <- matrix(abs(rnorm(T_obs * S)), nrow = T_obs, ncol = S)
K_ts <- matrix(abs(rnorm(T_obs * S)) + 1, nrow = T_obs, ncol = S)
zTMG <- rnorm(T_obs)

# 2. Create a dummy summary list (mimicking extract_posterior_summary)
summ <- list(
  theta_s = runif(S),
  kappa_s = runif(S),
  a3_s = runif(S),
  beta0_s = runif(S),
  beta1 = 0.5,
  gamma = 0.1
)

# 3. Run the function
metrics <- evaluate_oos(summ, Yz, Xz, zTMG, T_train = 15, 
                        COM_ts, K_ts, horizons = c(1, 2))
print(metrics)

}
