% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{jackknife}
\alias{jackknife}
\alias{jackknife-method}
\alias{jackknife,numeric-method}
\title{Jackknife Estimation}
\usage{
jackknife(object, ...)

\S4method{jackknife}{numeric}(object, do, ..., f = NULL)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector.}

\item{...}{Extra arguments to be passed to \code{do}.}

\item{do}{A \code{\link{function}} that takes \code{object} as an argument and returns a
single numeric value.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the leave-one-out
values of \code{do}) as argument.}
}
\value{
If \code{f} is \code{NULL} (the default), \code{jackknife()} returns a named \code{numeric}
vector with the following elements:
\describe{
\item{\code{original}}{The observed value of \code{do} applied to \code{object}.}
\item{\code{mean}}{The jackknife estimate of mean of \code{do}.}
\item{\code{bias}}{The jackknife estimate of bias of \code{do}.}
\item{\code{error}}{The jackknife estimate of standard error of \code{do}.}
}

If \code{f} is a \code{function}, \code{jackknife()} returns the result of \code{f} applied to
the leave-one-out values of \code{do}.
}
\description{
Jackknife Estimation
}
\examples{
x <- rnorm(20)

## Jackknife
jackknife(x, do = mean) # Sample mean

## Get the leave-one-out values instead of summary
jackknife(x, do = mean, f = function(x) { x })
}
\seealso{
Other resampling methods: 
\code{\link{bootstrap}()},
\code{\link{resample_multinomial}()},
\code{\link{resample_uniform}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
