% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/count.R
\docType{methods}
\name{count}
\alias{count}
\alias{count-method}
\alias{count,data.frame-method}
\alias{count,matrix-method}
\title{Count Values Using a Predicate}
\usage{
count(x, ...)

\S4method{count}{data.frame}(x, f, margin = 1, negate = FALSE, na.rm = FALSE, ...)

\S4method{count}{matrix}(x, f, margin = 1, negate = FALSE, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Further arguments to be passed to \code{f}.}

\item{f}{A predicate \code{\link{function}}.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscripts which the
function will be applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{negate}{A \code{\link{logical}} scalar: should the negation of \code{f} be used
instead of \code{f}?}

\item{na.rm}{A \code{\link{logical}} scalar: should \code{NA} values be stripped before the
computation proceeds?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Counts values by rows/columns using a predicate function.
}
\examples{
## Create a data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Count missing values in rows
count(X, f = is.na, margin = 1)
## Count non-missing values in columns
count(X, f = is.na, margin = 2, negate = TRUE)
}
\seealso{
Other data preparation tools: 
\code{\link{append_column}()},
\code{\link{append_rownames}()},
\code{\link{assign}()},
\code{\link{compact}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{get}()},
\code{\link{keep}()},
\code{\link{seek}()}
}
\author{
N. Frerebeau
}
\concept{data preparation tools}
