% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/append.R
\docType{methods}
\name{append_column}
\alias{append_column}
\alias{append_column-method}
\alias{append_column,data.frame-method}
\title{Add a (Named) Vector as a Column}
\usage{
append_column(x, ...)

\S4method{append_column}{data.frame}(x, column, after = 0, var = ".col")
}
\arguments{
\item{x}{A \code{\link{data.frame}}.}

\item{...}{Currently not used.}

\item{column}{A (named) \code{vector}.}

\item{after}{An \code{\link{integer}} specifying a subscript, after which the new
column is to be appended.}

\item{var}{A \code{\link{character}} string giving the name of the new column.}
}
\value{
A \code{\link{data.frame}}.
}
\description{
Add a (Named) Vector as a Column
}
\details{
If \code{column} is named, names will be matched to the row names of \code{x}. Only
the first match is retained, and elements of \code{column} without a match are
removed. This allows to add as a column a vector whose length is less than
the number of rows in \code{x} (\code{NA}s will be inserted).
}
\examples{
X <- data.frame(
  x = 1:5,
  y = 6:10,
  row.names = LETTERS[1:5]
)

Y <- c(D = 44, B = 55, Z = 22)

append_column(X, Y, after = 3)
}
\seealso{
Other data preparation tools: 
\code{\link{append_rownames}()},
\code{\link{assign}()},
\code{\link{compact}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{get}()},
\code{\link{keep}()},
\code{\link{seek}()}
}
\author{
N. Frerebeau
}
\concept{data preparation tools}
