% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoe_summary.R
\name{aoe_summary}
\alias{aoe_summary}
\title{Summarize Area of Effect Results}
\usage{
aoe_summary(x)
}
\arguments{
\item{x}{An \code{sf} object returned by \code{\link[=aoe]{aoe()}}.}
}
\value{
A data frame with one row per support, containing:
\describe{
\item{support_id}{Support identifier}
\item{n_total}{Total number of supported points}
\item{n_core}{Number of core points}
\item{n_halo}{Number of halo points}
\item{prop_core}{Proportion of points that are core}
\item{prop_halo}{Proportion of points that are halo}
}
}
\description{
Compute summary statistics for an AoE classification result, including
counts and proportions of core vs halo points per support.
}
\examples{
library(sf)

support <- st_as_sf(
  data.frame(id = 1),
  geometry = st_sfc(st_polygon(list(
    cbind(c(0, 10, 10, 0, 0), c(0, 0, 10, 10, 0))
  ))),
  crs = 32631
)

pts <- st_as_sf(
  data.frame(id = 1:4),
  geometry = st_sfc(
    st_point(c(5, 5)),
    st_point(c(2, 2)),
    st_point(c(15, 5)),
    st_point(c(12, 5))
  ),
  crs = 32631
)

result <- aoe(pts, support)
aoe_summary(result)

}
