% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{anthroplus_prevalence}
\alias{anthroplus_prevalence}
\title{Compute prevalence estimates}
\usage{
anthroplus_prevalence(
  sex,
  age_in_months = NA_real_,
  oedema = "n",
  height_in_cm = NA_real_,
  weight_in_kg = NA_real_,
  sw = NULL,
  cluster = NULL,
  strata = NULL
)
}
\arguments{
\item{sex}{A numeric or text variable containing gender information.
If it is numeric, its values must be: 1 for males and 2 for
females. If it is character, it must be "m" or "M" for males
and "f" or "F" for females. No z-scores will be calculated
if sex is missing.}

\item{age_in_months}{A numeric variable containing age information;
Age-related z-scores will NOT be calculated if age is missing.}

\item{oedema}{The values of this character variable must be "n", "N" or "2"
for non-oedema, and "y", "Y", "1" for oedema. Although it
is highly recommended that this variable is provided by the
survey, it is possible to run
the analysis without specifying this variable. If unspecified,
the default vector of all "n" with values considered as
non-oedema is used. Missing values will be
treated as non-oedema. For oedema, weight related z-scores
are NOT calculated (set to missing),
BUT they are treated as being < -3 SD in the weight-related
indicator prevalence (\code{\link{anthroplus_prevalence}})
estimation.}

\item{height_in_cm}{A numeric variable containing standing height
information, which must be in
centimeters. Height-related z-scores will not be
calculated if missing.}

\item{weight_in_kg}{A numeric variable containing body weight information,
which must be in kilograms. Weight-related z-scores are not
calculated if missing.}

\item{sw}{An optional numeric vector containing the sampling weights.
If NULL, no sampling weights are used.}

\item{cluster}{An optional integer vector representing clusters. If the value
is NULL this is treated as a survey without clusters. This is also the case
if all values are equal, then it is assumed there are also no clusters.}

\item{strata}{An optional integer vector representing strata. Pass NULL to
indicate that there are no strata.}
}
\value{
Returns a data.frame with prevalence estimates for the various
groups.

The output data frame includes prevalence estimates with corresponding
standard errors and confidence intervals,
and z-score summary statistics (mean and standard deviation) with most
common cut-offs describing the full index
distribution (-3, -2, -1, +1, +2, +3), and at disaggregated levels for
all available factors.

The resulting columns are coded with a \emph{prefix},
\emph{a prevalence indicator} and \emph{a suffix}:

\strong{Prefix:}
\describe{
\item{HA}{Height-for-age}
\item{WA}{Weight-for-age}
\item{BMI}{Body-mass-index-for-age}
}

\strong{Prevalence indicator:}
\describe{
\item{_3}{Prevalence corresponding to < -3 SD}
\item{_2}{Prevalence corresponding to < -2 SD}
\item{_1}{Prevalence corresponding to < -1 SD}
\item{1}{Prevalence corresponding to > +1 SD}
\item{2}{Prevalence corresponding to > +2 SD}
\item{3}{Prevalence corresponding to > +3 SD}
}

\strong{Suffix:}
\describe{
\item{_pop}{Weighted sample size}
\item{_unwpop}{Unweighted sample size}
\item{_r}{Mean/prevalence}
\item{_ll}{lower 95\% confidence interval limit}
\item{_ul}{upper 95\% confidence interval limit}
\item{_stdev}{Standard Deviation}
\item{_se}{Standard error}
}

\strong{For example:}
\describe{
\item{HA_r}{Height-for-age z-score mean}
\item{WA_stdev}{Weight-for-age z-score Standard Deviation}
\item{BMI_2_se}{Prevalence of BMI-for-age <-2 SD standard error}
\item{BMI_3_ll}{Prevalence of BMI-for-age <-3 SD lower 95\% confidence
interval limit}
}

Note that weight-for-age results are NA for the groups "All" and the two
"Sex" groups, as the indicator is only defined for age in months
between 60 and 120.
}
\description{
Prevalence estimates according to the WHO recommended standard analysis:
includes prevalence estimates with corresponding standard errors
and confidence intervals, and z-score summary statistics
(mean and standard deviation) with most common cut-offs describing the
full index distribution (-3, -2, -1, +1, +2, +3), and at disaggregated
levels for all available factors (age and sex).
}
\details{
In this function, all available (non-missing and non-flagged) z-score values
are used for each indicator-specific prevalence
estimation (standard analysis).

Note: the function temporarily sets the \code{survey} option
\code{survey.lonely.psu} to "adjust" and then restores the original value.
It is a wrapper around the \code{survey} package to compute
estimates for the different groups (e.g. by age or sex).

If not all parameter values have equal length, parameter values will be
repeated to match the maximum length.

Only cases with age_in_months between 60 (including) and 228 months
(including) are used for the analysis. The rest will be ignored.
}
\examples{
set.seed(1)
prev <- anthroplus_prevalence(
  sex = c(1, 2),
  age_in_months = rpois(100, 100),
  height_in_cm = rnorm(100, 100, 10),
  weight_in_kg = rnorm(100, 40, 10)
)
prev[, c(1, 4, 5, 6)]
}
