% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_test_that.R
\name{generate_tensors}
\alias{generate_tensors}
\title{Generate test tensors}
\usage{
generate_tensors(times, features, seq_len, pad_value)
}
\arguments{
\item{times}{\code{int} Maximal length of a sequence.}

\item{features}{\code{int} Number of features of the sequence.}

\item{seq_len}{Numeric \code{vector} containing the length of the given cases. The
length of this vector determines the value for 'Batch'. Values must be at least 1 and
maximal \code{times}.}

\item{pad_value}{\code{int} Value used to indicate padding.}
}
\value{
Returns an object of class \code{Tensor} from 'PyTorch'.
}
\description{
Functions generates a random test tensor that can be used for
testing methods and functions based on 'PyTorch'. The tensors have the shape
(Batch, Times,Features).
}
\note{
To request a \emph{R} array please use \link{generate_embeddings}.
}
\seealso{
Other Utils TestThat Developers: 
\code{\link{check_adjust_n_samples_on_CI}()},
\code{\link{generate_args_for_tests}()},
\code{\link{generate_embeddings}()},
\code{\link{get_current_args_for_print}()},
\code{\link{get_fixed_test_tensor}()},
\code{\link{get_test_data_for_classifiers}()},
\code{\link{monitor_test_time_on_CI}()},
\code{\link{random_bool_on_CI}()}
}
\concept{Utils TestThat Developers}
