% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow.R
\name{pow}
\alias{pow}
\title{Power for LWYY (fixed sample size)}
\usage{
pow(N, bta1, thta, tau, lam0, alp = 0.05, ar = 0.5)
}
\arguments{
\item{N}{Sample size.}

\item{bta1}{log-transform of rate ratio.}

\item{thta}{Variance of frailty parameter.}

\item{tau}{Expected follow-up time.}

\item{lam0}{Baseline rate for control.}

\item{alp}{Two-sided alpha-level.}

\item{ar}{Allocation ratio (Number control / Total)}
}
\value{
The power given the input assumptions.
}
\description{
Function to compute power at one-sided Type I control level alp/2.
}
\details{
Note: Approximation breaks down in no event scenario. For example, pow(N=1000, bta1 = log(1), thta = 1, lam0 = 0, tau = 1, alp = 0.05) returns a power of 0.025
}
\examples{

pow(N = 500, bta1 = log(0.8), thta = 2, tau = 1, lam0 = 1.1, alp = 0.05)
pow(N = 500, bta1 = log(0.8), thta = 3, tau = 1, lam0 = 1.1, alp = 0.05)

if (require("dplyr") & require("tidyr")) {

  assumptions = tibble(alp = 0.05) \%>\%
  crossing(
    tau = c(0.8,0.9, 1.0),
    RR = c(0.6, 0.7, 0.8),
    lam0 = c(3, 3.5),
    thta = c(2, 3, 4),
    N = c(500, 1000)
  ) \%>\%
    mutate(pow = pow(N = N, bta1 = log(RR), thta = thta, tau = tau, lam0 = lam0, alp = alp))

  assumptions \%>\% data.frame()

}

}
